/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.ai.goals.AllDirectionsTargetGoal;
import com.alexander.mutantmore.ai.goals.ApproachTargetGoal;
import com.alexander.mutantmore.ai.goals.LookAtTargetGoal;
import com.alexander.mutantmore.config.MutantMoreGroupedOptionsClientConfig;
import com.alexander.mutantmore.config.MutantMoreGroupedOptionsCommonConfig;
import com.alexander.mutantmore.config.MutantWitherSkeletonClientConfig;
import com.alexander.mutantmore.config.MutantWitherSkeletonCommonConfig;
import com.alexander.mutantmore.entities.FireSlash;
import com.alexander.mutantmore.entities.MutantWitherSkeletonBodyPart;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.DamageSourceInit;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.MusicInit;
import com.alexander.mutantmore.init.ParticleTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.interfaces.IHasBossMusic;
import com.alexander.mutantmore.interfaces.IMutatable;
import com.alexander.mutantmore.interfaces.INaturallySpawningMutant;
import com.alexander.mutantmore.util.BossMusicUtils;
import com.alexander.mutantmore.util.MiscUtils;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantWitherSkeleton
extends Monster
implements IAnimatable,
IAnimationTickable,
IMutatable,
INaturallySpawningMutant,
IHasBossMusic {
    private static final EntityDataAccessor<Integer> TARGETED_ENTITY_ID = SynchedEntityData.m_135353_(MutantWitherSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID SPEED_MODIFIER_DUCKING_UUID = UUID.fromString("adfdf75b-53d7-45c4-bee6-81bcc4a1632b");
    private AttributeModifier SPEED_MODIFIER_DUCKING;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int specialAnimationTick;
    public final int specialAnimationLength = 92;
    public int introAnimationTick;
    public final int introAnimationLength = 40;
    public int attackAnimationTickLeft;
    public int attackAnimationTickRight;
    public final int attackAnimationLRAnimationLength = 25;
    public final int attackAnimationLRActionPoint = 10;
    public int attackAnimationTickBoth;
    public final int attackAnimationBothAnimationLength = 40;
    public final int attackAnimationBothActionPoint = 20;
    public int jumpAnimationTick;
    public int jumpAnimationLength = 15;
    public int jumpAnimationActionPoint = 1;
    public int fireSlashAnimationTick;
    public int fireSlashAnimationLength = 40;
    public int fireSlashAnimationActionPoint1 = 25;
    public int fireSlashAnimationActionPoint2 = 10;
    public int ribCrushAnimationTick;
    public int ribCrushAnimationLength = 20;
    public int ribCrushAnimationActionPoint = 7;
    public int eyeTextureChange = 0;
    public boolean f_20899_;
    public boolean jumpedFromLava;
    public int jumpCooldown;
    public int jumpCooldownTime = 20;
    public int stunnedAnimationTick;
    public int stunnedAnimationLength = (Integer)MutantWitherSkeletonCommonConfig.stun_length.get();
    public static EntityDimensions crouchingDimensions = EntityDimensions.m_20395_((float)1.25f, (float)2.4f);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6).m_7003_(true);
    private int destroyBlocksTick;

    public MutantWitherSkeleton(EntityType<? extends MutantWitherSkeleton> p_i50189_1_, Level p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.f_21364_ = (Integer)MutantWitherSkeletonCommonConfig.exp_reward.get();
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.SPEED_MODIFIER_DUCKING = new AttributeModifier(SPEED_MODIFIER_DUCKING_UUID, "Ducking speed decrease", -((Double)MutantWitherSkeletonCommonConfig.ducking_movement_speed_decrease.get()).doubleValue(), AttributeModifier.Operation.ADDITION);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RemainStationaryGoal());
        if (((Boolean)MutantWitherSkeletonCommonConfig.uses_jump.get()).booleanValue()) {
            this.f_21345_.m_25352_(1, (Goal)new LargeJumpGoal(this));
        }
        if (((Boolean)MutantWitherSkeletonCommonConfig.uses_fire_slash.get()).booleanValue()) {
            this.f_21345_.m_25352_(2, (Goal)new FireSlashAttackGoal(this));
        }
        if (((Boolean)MutantWitherSkeletonCommonConfig.uses_rib_crush.get()).booleanValue()) {
            this.f_21345_.m_25352_(2, (Goal)new RibCrushAttackGoal(this));
        }
        if (((Boolean)MutantWitherSkeletonCommonConfig.uses_default_attack.get()).booleanValue()) {
            this.f_21345_.m_25352_(3, (Goal)new BasicAttackGoal(this));
        }
        this.f_21345_.m_25352_(4, (Goal)new ApproachTargetGoal((PathfinderMob)this, (Double)MutantWitherSkeletonCommonConfig.follow_target_wanted_distance.get(), (Double)MutantWitherSkeletonCommonConfig.following_movement_speed_multiplier.get(), true));
        this.f_21345_.m_25352_(5, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 10.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26146_(6000));
        if (((Boolean)MutantWitherSkeletonCommonConfig.attacks_players.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutants_attack_players_off.get()).booleanValue()) {
            this.f_21346_.m_25352_(1, (Goal)new AllDirectionsTargetGoal<Player>((Mob)this, Player.class, true).m_26146_(6000));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 20, false, false, entity -> entity.m_6095_().m_204039_(TagInit.EntityTypes.MUTANT_WITHER_SKELETON_TARGETS)){

            protected AABB m_7255_(double p_26069_) {
                return this.f_26135_.m_20191_().m_82377_(((Double)MutantWitherSkeletonCommonConfig.follow_non_player_distance.get()).doubleValue(), ((Double)MutantWitherSkeletonCommonConfig.follow_non_player_distance.get()).doubleValue(), ((Double)MutantWitherSkeletonCommonConfig.follow_non_player_distance.get()).doubleValue());
            }
        });
        if (((Boolean)MutantWitherSkeletonCommonConfig.attacks_baby_turtles.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, (Goal)new AllDirectionsTargetGoal<Turtle>((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_).m_26146_(6000));
        }
    }

    protected PathNavigation m_6037_(Level p_33348_) {
        return new MutantWitherSkeletonNavigation((Mob)this, p_33348_);
    }

    public boolean m_6779_(LivingEntity target) {
        return this.canTarget((Entity)target) && super.m_6779_(target);
    }

    boolean canTarget(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_WITHER_SKELETON_CANT_TARGET, (Entity)this, target, (Entity)this, null);
    }

    boolean canHarm(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_WITHER_SKELETON_CANT_HURT, (Entity)this, target, (Entity)this, null);
    }

    public boolean hasFlamingEyes() {
        return (Boolean)MutantWitherSkeletonClientConfig.eyes_set_fire.get() == false ? false : this.stunnedAnimationTick <= 0 && (this.introAnimationTick > 0 || this.attackAnimationTickBoth > 0 || this.fireSlashAnimationTick > 0 || this.m_20077_() || this.jumpedFromLava);
    }

    public boolean shouldBeStationary() {
        return this.introAnimationTick > 0 || this.stunnedAnimationTick > 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 170.0).m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setConfigurableAttributeValues() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)MutantWitherSkeletonCommonConfig.max_health.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)MutantWitherSkeletonCommonConfig.armour.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)MutantWitherSkeletonCommonConfig.armour_toughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)MutantWitherSkeletonCommonConfig.knockback_resistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)MutantWitherSkeletonCommonConfig.follow_player_distance.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)MutantWitherSkeletonCommonConfig.movement_speed.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)MutantWitherSkeletonCommonConfig.attack_knockback.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)MutantWitherSkeletonCommonConfig.basic_attack_damage.get()).doubleValue());
        this.m_21153_(this.m_21233_());
    }

    public boolean m_21481_(BlockPathTypes p_21482_) {
        return true;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public float m_6100_() {
        return this.m_21224_() ? 1.0f : super.m_6100_();
    }

    protected float m_6121_() {
        return this.m_21224_() ? 3.0f : super.m_6121_();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_(this.m_20077_() ? (SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_STEP_LAVA.get() : (SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_STEP.get(), 0.75f, 1.0f);
    }

    public boolean m_203441_(FluidState p_204067_) {
        return (Boolean)MutantWitherSkeletonCommonConfig.walks_on_lava.get() != false && p_204067_.m_205070_(FluidTags.f_13132_);
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.destroyBlocksTick > 0) {
            --this.destroyBlocksTick;
            if (this.destroyBlocksTick == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                int j1 = Mth.m_14107_((double)this.m_20186_());
                int i2 = Mth.m_14107_((double)this.m_20185_());
                int j2 = Mth.m_14107_((double)this.m_20189_());
                boolean flag = false;
                AABB aabb = this.m_20191_().m_82377_(1.0, 0.0, 1.0).m_82386_(0.0, 0.1, 0.0);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                    flag = this.f_19853_.m_46953_(blockpos, (Boolean)MutantWitherSkeletonCommonConfig.hurt_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false, (Entity)this) || flag;
                }
                if (flag) {
                    this.f_19853_.m_5898_((Player)null, 1022, this.m_20183_(), 0);
                }
            }
        }
        super.m_8024_();
    }

    public void m_6452_(ServerPlayer p_31488_) {
        super.m_6452_(p_31488_);
        this.bossEvent.m_6539_(p_31488_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19862_ && ((Boolean)MutantWitherSkeletonCommonConfig.walk_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue()) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!blockstate.m_204336_(TagInit.Blocks.MUTANT_WITHER_SKELETON_WALKS_THROUGH)) continue;
                flag = this.f_19853_.m_46953_(blockpos, (Boolean)MutantWitherSkeletonCommonConfig.walk_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false, (Entity)this) || flag;
            }
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (!this.f_19853_.f_46443_) {
            if (source != null && source == DamageSource.f_19317_) {
                this.m_5496_(SoundEvents.f_12038_, this.m_6121_(), this.m_6100_());
            } else {
                this.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_DEATH.get(), this.m_6121_(), 1.0f);
                if (((Boolean)MutantWitherSkeletonCommonConfig.explode_into_parts.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutants_explode_into_parts_off.get()).booleanValue()) {
                    int i;
                    ShakeCameraEvent.shake(this.f_19853_, 60, 0.035f, this.m_20183_(), 25, CameraShakePriority.STRONG_MOB_ACTION);
                    this.createBodyPart(0);
                    this.createBodyPart(2);
                    for (i = 0; i < 6; ++i) {
                        this.createBodyPart(1);
                    }
                    for (i = 0; i < 8; ++i) {
                        this.createBodyPart(3);
                    }
                    for (i = 0; i < 2; ++i) {
                        this.createBodyPart(4);
                    }
                } else {
                    ResourceLocation resourcelocation = new ResourceLocation("mutantmore", "loot_tables/entities/mutant_wither_skeleton_parts.json");
                    LootTable loottable = this.f_19853_.m_7654_().m_129898_().m_79217_(resourcelocation);
                    LootContext.Builder lootcontext$builder = this.m_7771_(this.f_20889_ > 0, source);
                    LootContext ctx = lootcontext$builder.m_78975_(LootContextParamSets.f_81415_);
                    loottable.m_230922_(ctx).forEach(arg_0 -> ((MutantWitherSkeleton)this).m_19983_(arg_0));
                }
                this.dropAllDieLoot(source);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (!this.m_6673_(p_21016_) && this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 20;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    protected void m_6668_(DamageSource source) {
    }

    protected void dropAllDieLoot(DamageSource source) {
        Entity entity = source.m_7639_();
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)source);
        this.captureDrops(new ArrayList());
        boolean flag = this.f_20889_ > 0;
        this.m_7625_(source, flag);
        this.m_7472_(source, i, flag);
        this.m_5907_();
        this.m_21226_();
        Collection drops = this.captureDrops(null);
        if (!ForgeHooks.onLivingDrops((LivingEntity)this, (DamageSource)source, (Collection)drops, (int)i, (this.f_20889_ > 0 ? 1 : 0) != 0)) {
            drops.forEach(e -> this.f_19853_.m_7967_((Entity)e));
        }
    }

    public ItemEntity m_5552_(ItemStack p_19985_, float p_19986_) {
        if (p_19985_.m_41619_()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)p_19986_, this.m_20189_(), p_19985_);
        itementity.m_32060_();
        itementity.m_32064_();
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.f_19853_.m_7967_((Entity)itementity);
        }
        return itementity;
    }

    public void createBodyPart(int partNumber) {
        if (!this.f_19853_.f_46443_) {
            MutantWitherSkeletonBodyPart part = new MutantWitherSkeletonBodyPart(this.f_19853_, (Mob)this, partNumber);
            part.glows = (Boolean)MutantWitherSkeletonCommonConfig.parts_glow.get();
            part.damage = ((Double)MutantWitherSkeletonCommonConfig.part_collision_damage.get()).floatValue();
            part.witherLength = (Integer)MutantWitherSkeletonCommonConfig.part_collision_wither_mobs_length.get();
            part.witherLevel = (Integer)MutantWitherSkeletonCommonConfig.part_collision_wither_mobs_level.get();
            part.despawnTime = (Integer)MutantWitherSkeletonCommonConfig.part_persist_length.get();
            part.m_20256_(part.m_20184_().m_82520_((double)(this.f_19796_.m_188501_() * 0.8f * 2.0f - 0.8f), (double)(this.f_19796_.m_188501_() * 0.25f + 0.1f), (double)(this.f_19796_.m_188501_() * 0.8f * 2.0f - 0.8f)));
            this.f_19853_.m_7967_((Entity)part);
        }
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        return p_19975_ == Pose.CROUCHING ? crouchingDimensions : super.m_6972_(p_19975_);
    }

    public float getStepHeight() {
        return 1.6f;
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGETED_ENTITY_ID, (Object)0);
    }

    public int getTargetedEntityID() {
        return (Integer)this.f_19804_.m_135370_(TARGETED_ENTITY_ID);
    }

    public void setTargetedEntityID(int setTo) {
        this.f_19804_.m_135381_(TARGETED_ENTITY_ID, (Object)setTo);
    }

    public void m_6075_() {
        int k;
        int j;
        BlockPos pos;
        BlockState blockstate;
        int i;
        super.m_6075_();
        this.m_6210_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null && !this.m_5448_().m_213877_()) {
                this.setTargetedEntityID(this.m_5448_().m_19879_());
            } else {
                this.setTargetedEntityID(0);
            }
        }
        if ((this.jumpedFromLava || this.m_20077_()) && ((Boolean)MutantWitherSkeletonClientConfig.lava_jump_trail.get()).booleanValue()) {
            for (i = 0; i < 1; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypeInit.FIRE_TRAIL.get(), this.m_20208_(0.8), this.m_20186_() + 0.5, this.m_20262_(0.8), d0, d1, d2);
            }
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0 && !(blockstate = this.f_19853_.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_()) {
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
        }
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.f_19861_ = true;
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
        if (((Boolean)MutantWitherSkeletonClientConfig.show_health_bar.get()).booleanValue() || ((Boolean)MutantMoreGroupedOptionsClientConfig.show_health_bars_on.get()).booleanValue()) {
            if (this.m_5448_() != null && this.m_6084_()) {
                if (this.m_5448_() instanceof ServerPlayer) {
                    this.bossEvent.m_6543_((ServerPlayer)this.m_5448_());
                }
                for (ServerPlayer player : this.f_19853_.m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(20.0), MiscUtils.ALIVE)) {
                    this.bossEvent.m_6543_(player);
                }
            } else if (this.m_5448_() == null || !this.m_6084_()) {
                for (ServerPlayer player : this.f_19853_.m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(75.0), MiscUtils.ALIVE)) {
                    this.bossEvent.m_6539_(player);
                }
            }
        }
        if (!this.m_20096_() && this.f_20899_ && this.f_19863_ && !this.f_201939_ && !this.f_19853_.f_46443_ && ((Boolean)MutantWitherSkeletonCommonConfig.jump_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue()) {
            int j1 = Mth.m_14107_((double)this.m_20186_());
            int i2 = Mth.m_14107_((double)this.m_20185_());
            int j2 = Mth.m_14107_((double)this.m_20189_());
            boolean flag = false;
            for (int j3 = -1; j3 <= 2; ++j3) {
                for (int k2 = -1; k2 <= 2; ++k2) {
                    for (int k3 = 3; k3 <= 5; ++k3) {
                        int l2 = i2 + j3;
                        int l = j1 + k3;
                        int i1 = j2 + k2;
                        BlockPos blockpos = new BlockPos(l2, l, i1);
                        BlockState blockstate2 = this.f_19853_.m_8055_(blockpos);
                        if (blockstate2.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                        flag = this.f_19853_.m_46953_(blockpos, (Boolean)MutantWitherSkeletonCommonConfig.jump_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false, (Entity)this) || flag;
                    }
                }
            }
            if (flag && ((Boolean)MutantWitherSkeletonCommonConfig.jump_breaks_once.get()).booleanValue()) {
                this.f_20899_ = false;
                this.jumpedFromLava = false;
                this.f_19853_.m_7605_((Entity)this, (byte)8);
                this.m_20334_(0.0, 0.0, 0.0);
                this.stunnedAnimationTick = this.stunnedAnimationLength;
                this.f_19853_.m_7605_((Entity)this, (byte)9);
                ShakeCameraEvent.shake(this.f_19853_, 20, 0.05f, this.m_20183_(), 10, CameraShakePriority.STRONG_MOB_ACTION);
                this.f_19853_.m_5898_((Player)null, 1022, this.m_20183_(), 0);
            }
        }
        if (this.f_20899_ && this.m_5448_() != null && this.m_20184_().m_7096_() == 0.0 && this.m_20184_().m_7094_() == 0.0) {
            this.f_19790_ = this.m_20185_();
            this.f_19791_ = this.m_20186_();
            this.f_19792_ = this.m_20189_();
            this.m_20334_(0.0, this.m_20184_().m_7098_(), 0.0);
            double x = this.m_5448_().m_20185_() - this.m_20185_();
            double y = this.m_5448_().m_20186_() - this.m_20186_();
            double z = this.m_5448_().m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            this.m_20256_(this.m_20184_().m_82549_(new Vec3(x / d * (double)0.2f, 0.0, z / d * (double)0.2f).m_82490_(2.0)));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (!this.f_19853_.f_46443_ && this.m_20096_() && this.f_201939_ && this.f_20899_) {
            if (this.jumpedFromLava) {
                this.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_BIGLAND_LAVA.get(), 2.5f, 1.0f);
                for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82377_(3.0, 1.0, 3.0))) {
                    entity.m_20254_(((Integer)MutantWitherSkeletonCommonConfig.lava_jump_set_mob_on_fire_length.get()).intValue());
                }
            }
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_BIGLAND.get(), 2.5f, 1.0f);
            this.f_20899_ = false;
            this.jumpedFromLava = false;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
        boolean markedCrouching = false;
        for (int i2 = -2; i2 < 3; ++i2) {
            for (int j4 = -2; j4 < 3; ++j4) {
                markedCrouching = markedCrouching || !this.f_19853_.m_8055_(this.m_20183_().m_6630_(4).m_122013_(i2).m_122030_(j4)).m_60795_() || !this.f_19853_.m_8055_(this.m_20183_().m_6630_(3).m_122013_(i2).m_122030_(j4)).m_60795_();
            }
        }
        if (markedCrouching || this.m_5830_()) {
            this.m_20124_(Pose.CROUCHING);
        } else {
            this.m_20124_(Pose.STANDING);
        }
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_20089_() == Pose.CROUCHING || this.m_20077_()) {
            if (!modifiableattributeinstance.m_22109_(this.SPEED_MODIFIER_DUCKING)) {
                modifiableattributeinstance.m_22118_(this.SPEED_MODIFIER_DUCKING);
            }
        } else {
            modifiableattributeinstance.m_22130_(this.SPEED_MODIFIER_DUCKING);
        }
        if (this.f_19797_ % 5 == 0) {
            ++this.eyeTextureChange;
        }
        Vec3 velocity = this.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (!this.f_19853_.f_46443_ && groundSpeed <= 0.1f && this.specialAnimationTick <= 0 && this.f_19796_.m_188503_(400) == 0 && (this.m_5448_() == null || this.m_5448_().m_21224_() || this.m_5448_().m_213877_())) {
            this.specialAnimationTick = this.specialAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.m_216990_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_LOOK.get());
        }
        if (this.specialAnimationTick == this.specialAnimationLength - 20) {
            this.m_216990_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_LOOK.get());
        }
        if (this.specialAnimationTick == this.specialAnimationLength - 70) {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_ROAR_SHORT.get(), 1.5f, 1.0f);
        }
        this.tickDownAnimTimers();
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d0 = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double d1 = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double d2 = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.specialAnimationTick = 92;
        } else if (p_28844_ == 11) {
            this.introAnimationTick = 40;
        } else if (p_28844_ == 33) {
            this.attackAnimationTickRight = 25;
        } else if (p_28844_ == 36) {
            this.attackAnimationTickLeft = 25;
        } else if (p_28844_ == 37) {
            this.attackAnimationTickBoth = 40;
        } else if (p_28844_ == 44) {
            this.ribCrushAnimationTick = this.ribCrushAnimationLength;
        } else if (p_28844_ == 5) {
            this.fireSlashAnimationTick = this.fireSlashAnimationLength;
        } else if (p_28844_ == 6) {
            this.jumpAnimationTick = this.jumpAnimationLength;
        } else if (p_28844_ == 7) {
            this.f_20899_ = true;
            this.jumpCooldown = this.jumpCooldownTime;
        } else if (p_28844_ == 8) {
            if (this.jumpedFromLava && ((Boolean)MutantWitherSkeletonClientConfig.lava_jump_trail.get()).booleanValue()) {
                for (int i = 0; i < 15; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.05;
                    double d1 = this.f_19796_.m_188583_() * 0.05;
                    double d2 = this.f_19796_.m_188583_() * 0.05;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypeInit.FIRE_TRAIL.get(), this.m_20208_(1.2), this.m_20186_() - 1.0, this.m_20262_(1.2), d0, d1, d2);
                }
            }
            this.f_20899_ = false;
            this.jumpedFromLava = false;
        } else if (p_28844_ == 9) {
            this.stunnedAnimationTick = this.stunnedAnimationLength;
        } else if (p_28844_ == 10) {
            this.createWitheringHeartParticles();
        } else if (p_28844_ == 12) {
            this.jumpedFromLava = true;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void createWitheringHeartParticles() {
        int i1 = 3;
        if (this.attackAnimationTickLeft > 0 || this.attackAnimationTickRight > 0) {
            i1 = 3;
        }
        if (this.attackAnimationTickBoth > 0) {
            i1 = 5;
        }
        if (this.ribCrushAnimationTick > 0) {
            i1 = 7;
        }
        for (int i = 0; i < i1; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypeInit.WITHERING_HEART.get(), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean m_7327_(Entity p_34169_) {
        if (!super.m_7327_(p_34169_)) {
            return false;
        }
        if (p_34169_ instanceof LivingEntity) {
            ((LivingEntity)p_34169_).m_147207_(new MobEffectInstance(MobEffects.f_19615_, 120, 1), (Entity)this);
        }
        return true;
    }

    public boolean doHurtTarget(Entity target, EquipmentSlot slot) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_6844_(slot), (MobType)((LivingEntity)target).m_6336_());
            f1 += (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)this.m_6844_(slot));
        }
        if ((i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.m_6844_(slot))) > 0) {
            target.m_20254_(i * 4);
        }
        if (flag = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), f)) {
            if (f1 > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                MiscUtils.maybeDisableShield((Mob)this, player, this.m_6844_(slot), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, target);
            this.m_21335_(target);
        }
        if (flag && target instanceof LivingEntity) {
            ((LivingEntity)target).m_147207_(new MobEffectInstance(MobEffects.f_19615_, ((Integer)MutantWitherSkeletonCommonConfig.basic_attack_wither_mobs_length.get()).intValue(), ((Integer)MutantWitherSkeletonCommonConfig.basic_attack_wither_mobs_level.get()).intValue()), (Entity)this);
        }
        return flag;
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() == MobEffects.f_19615_ ? false : super.m_7301_(p_34192_);
    }

    protected float m_6431_(Pose p_34186_, EntityDimensions p_34187_) {
        return p_34186_ == Pose.CROUCHING ? MutantWitherSkeleton.crouchingDimensions.f_20378_ - 0.1f : 3.75f;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.introAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_mutated", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.stunnedAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_stunned", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.jumpAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_jump", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.fireSlashAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_fire_slash", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.ribCrushAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_rib_crush", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.attackAnimationTickRight > 0 || this.attackAnimationTickLeft > 0 || this.attackAnimationTickBoth > 0) {
            if (this.attackAnimationTickBoth > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_attack_both", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.attackAnimationTickRight > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_attack_right", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_attack_left", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.f_20899_) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_jumping", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.1f) || !(event.getLimbSwingAmount() < 0.1f)) {
            if (this.m_6047_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_walk_crouching", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.specialAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_idle_rare", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_6047_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_idle_crouching", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_wither_skeleton_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void tickDownAnimTimers() {
        if (this.specialAnimationTick > 0) {
            --this.specialAnimationTick;
        }
        if (this.introAnimationTick > 0) {
            --this.introAnimationTick;
        }
        if (this.attackAnimationTickBoth > 0) {
            --this.attackAnimationTickBoth;
        }
        if (this.attackAnimationTickLeft > 0) {
            --this.attackAnimationTickLeft;
        }
        if (this.attackAnimationTickRight > 0) {
            --this.attackAnimationTickRight;
        }
        if (this.fireSlashAnimationTick > 0) {
            --this.fireSlashAnimationTick;
        }
        if (this.jumpAnimationTick > 0) {
            --this.jumpAnimationTick;
        }
        if (this.ribCrushAnimationTick > 0) {
            --this.ribCrushAnimationTick;
        }
        if (this.stunnedAnimationTick > 0) {
            this.stunEffect();
            --this.stunnedAnimationTick;
        }
    }

    public void m_6043_() {
        if (!((Boolean)MutantWitherSkeletonCommonConfig.despawns.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutant_despawning_on.get()).booleanValue()) {
            if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
                this.m_146870_();
            } else {
                this.f_20891_ = 0;
            }
        } else {
            super.m_6043_();
        }
    }

    @Override
    public void onMutantSpawned(MobSpawnType spawnReason) {
        this.m_20124_(Pose.CROUCHING);
        this.m_213945_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
        this.m_213946_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
        if (!this.f_19853_.f_46443_) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)(aabb.f_82289_ + 1.0)), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    @Override
    public void onMutated() {
        this.m_20124_(Pose.CROUCHING);
        this.m_213945_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
        this.m_213946_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
        if (!this.f_19853_.f_46443_) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)(aabb.f_82289_ + 1.0)), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
        this.introAnimationTick = 40;
        this.f_19853_.m_7605_((Entity)this, (byte)11);
        this.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_ROAR.get(), 2.5f, 1.0f);
        ShakeCameraEvent.shake(this.f_19853_, 80, 0.05f, this.m_20183_(), 25, CameraShakePriority.STRONG_MOB_ACTION);
    }

    protected void m_213945_(RandomSource p_219135_, DifficultyInstance p_219136_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.BLAZING_SCIMITAR.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)ItemInit.BLAZING_SCIMITAR.get()));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        this.m_213945_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
        this.m_213946_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
        this.setConfigurableAttributeValues();
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    @Override
    public boolean shouldPlayMusic() {
        if (this.f_19853_.f_46443_) {
            return BossMusicUtils.canMobPlayBossMusic((Mob)this, (Boolean)MutantWitherSkeletonClientConfig.play_battle_music.get(), this.getTargetedEntityID());
        }
        return false;
    }

    @Override
    public Music getBossMusic() {
        return MusicInit.MUTANT_THEME_FAST;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return MutantWitherSkeleton.this.shouldBeStationary();
        }
    }

    class LargeJumpGoal
    extends Goal {
        public MutantWitherSkeleton mob;
        @Nullable
        public LivingEntity target;

        public LargeJumpGoal(MutantWitherSkeleton mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            int chance = 0;
            if (this.target != null) {
                chance = (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.close_jump_distance.get() && this.mob.m_142582_((Entity)this.target) ? (Integer)MutantWitherSkeletonCommonConfig.close_jump_chance.get() : ((double)this.mob.m_20270_((Entity)this.target) >= (Double)MutantWitherSkeletonCommonConfig.far_jump_distance.get() ? ((Integer)MutantWitherSkeletonCommonConfig.far_jump_chance.get()).intValue() : ((Integer)MutantWitherSkeletonCommonConfig.medium_jump_chance.get()).intValue());
            }
            return !(this.target == null || this.target.m_213877_() || this.target.m_21224_() || this.mob.f_20899_ || (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.min_jump_distance.get() && this.mob.m_142582_((Entity)this.target) || MutantWitherSkeleton.this.f_19796_.m_188503_(chance) != 0 || this.mob.m_6047_() || !this.animationsUseable());
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_IDLE.get());
            this.mob.jumpAnimationTick = this.mob.jumpAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)6);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target != null && (this.mob.jumpAnimationTick == this.mob.jumpAnimationActionPoint || this.mob.jumpAnimationTick == this.mob.jumpAnimationActionPoint)) {
                if (this.mob.m_20077_()) {
                    this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_BIGJUMP_LAVA.get(), 3.0f, 1.0f);
                    this.mob.jumpedFromLava = true;
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)12);
                } else {
                    this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_BIGJUMP.get(), 3.0f, 1.0f);
                }
                this.mob.f_20899_ = true;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)7);
                this.mob.jumpCooldown = this.mob.jumpCooldownTime;
                double d0 = this.target.m_20185_() - this.mob.m_20185_();
                double d1 = this.target.m_20186_() - this.mob.m_20186_();
                double d2 = this.target.m_20189_() - this.mob.m_20189_();
                this.mob.m_20334_(d0 * 0.15, 0.8 + Mth.m_14008_((double)(d1 * 0.075), (double)0.0, (double)10.0), d2 * 0.15);
            }
        }

        public boolean animationsUseable() {
            return this.mob.jumpAnimationTick <= 0;
        }
    }

    class FireSlashAttackGoal
    extends Goal {
        public MutantWitherSkeleton mob;
        @Nullable
        public LivingEntity target;

        public FireSlashAttackGoal(MutantWitherSkeleton mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && (double)this.mob.m_20270_((Entity)this.target) >= (Double)MutantWitherSkeletonCommonConfig.min_fire_slash_distance.get() && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.max_fire_slash_distance.get() && !this.mob.m_20071_() && (double)this.distanceToY((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.max_fire_slash_y_distance.get() && MutantWitherSkeleton.this.f_19796_.m_188503_(((Integer)MutantWitherSkeletonCommonConfig.fire_slash_chance.get()).intValue()) == 0 && this.animationsUseable() && this.mob.m_142582_((Entity)this.target);
        }

        public float distanceToY(Entity p_20271_) {
            float f1 = (float)(this.mob.m_20186_() - p_20271_.m_20186_());
            return Mth.m_14116_((float)(f1 * f1));
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_IDLE.get());
            this.mob.fireSlashAnimationTick = this.mob.fireSlashAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)5);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.mob.fireSlashAnimationTick == this.mob.fireSlashAnimationActionPoint1 + 5 || this.mob.fireSlashAnimationTick == this.mob.fireSlashAnimationActionPoint2 + 5) {
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_SWOOSH.get(), 2.0f, 1.0f);
            }
            if (this.target != null && (this.mob.fireSlashAnimationTick == this.mob.fireSlashAnimationActionPoint1 || this.mob.fireSlashAnimationTick == this.mob.fireSlashAnimationActionPoint2)) {
                FireSlash projectile = new FireSlash(this.mob.f_19853_, (Entity)this.mob, this.mob.m_20185_(), this.mob.m_20188_() - 0.25, this.mob.m_20189_(), true);
                projectile.damage = ((Double)MutantWitherSkeletonCommonConfig.fire_slash_damage.get()).floatValue();
                projectile.fireLength = (Integer)MutantWitherSkeletonCommonConfig.fire_slash_set_mob_on_fire_length.get();
                projectile.griefing = (Boolean)MutantWitherSkeletonCommonConfig.fire_slash_griefing.get() != false && (Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get() == false;
                projectile.ignoresInvulTime = (Boolean)MutantWitherSkeletonCommonConfig.ignores_invulnerability_time.get();
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_FIRE_SLASH.get(), 2.0f, 1.0f);
                Vec3 vec31 = this.mob.m_20289_(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vec31), 0.0f, true);
                Vec3 vec3 = this.mob.m_20252_(1.0f);
                Vector3f vector3f = new Vector3f(vec3);
                vector3f.m_122251_(quaternion);
                projectile.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 1.6f, 1.0f);
                this.mob.f_19853_.m_7967_((Entity)projectile);
            }
        }

        public boolean animationsUseable() {
            return this.mob.fireSlashAnimationTick <= 0;
        }
    }

    class RibCrushAttackGoal
    extends Goal {
        public MutantWitherSkeleton mob;
        @Nullable
        public LivingEntity target;

        public RibCrushAttackGoal(MutantWitherSkeleton mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.max_rib_crush_distance.get() && MiscUtils.randomPercent((Integer)MutantWitherSkeletonCommonConfig.rib_crush_chance.get()) && this.animationsUseable() && this.mob.m_142582_((Entity)this.target);
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_IDLE.get());
            this.mob.ribCrushAnimationTick = this.mob.ribCrushAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)44);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.max_rib_crush_damage_distance.get() && this.mob.ribCrushAnimationTick == this.mob.ribCrushAnimationActionPoint) {
                if (((Boolean)MutantWitherSkeletonCommonConfig.ignores_invulnerability_time.get()).booleanValue()) {
                    this.target.f_19802_ = 0;
                }
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_RIBCRUSH.get(), 1.5f, 1.0f);
                boolean flag = this.target.m_6469_(DamageSourceInit.ribCrushAttack((LivingEntity)this.mob), ((Double)MutantWitherSkeletonCommonConfig.rib_crush_damage.get()).floatValue());
                MiscUtils.disableShield(this.target, (Integer)MutantWitherSkeletonCommonConfig.rib_crush_disable_shield_length.get());
                if (flag) {
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)10);
                    this.mob.m_5634_(((Double)MutantWitherSkeletonCommonConfig.rib_crush_leech_health_amount.get()).floatValue());
                    this.target.m_147207_(new MobEffectInstance(MobEffects.f_19615_, ((Integer)MutantWitherSkeletonCommonConfig.rib_crush_wither_mobs_length.get()).intValue(), ((Integer)MutantWitherSkeletonCommonConfig.rib_crush_blocked_wither_mobs_length.get()).intValue()), (Entity)this.mob);
                } else {
                    this.target.m_147207_(new MobEffectInstance(MobEffects.f_19615_, ((Integer)MutantWitherSkeletonCommonConfig.rib_crush_blocked_wither_mobs_length.get()).intValue(), ((Integer)MutantWitherSkeletonCommonConfig.rib_crush_blocked_wither_mobs_level.get()).intValue()), (Entity)this.mob);
                }
                ShakeCameraEvent.shake(this.mob.f_19853_, 40, 0.15f, this.mob.m_20183_(), 15, CameraShakePriority.STRONG_MOB_ACTION);
                this.target.m_5997_((double)((1.0f + MutantWitherSkeleton.this.f_19796_.m_188501_() * 0.4f) * (float)(MutantWitherSkeleton.this.f_19796_.m_188499_() ? 1 : -1)), (double)(0.4f + MutantWitherSkeleton.this.f_19796_.m_188501_() * 0.8f), (double)((1.0f + MutantWitherSkeleton.this.f_19796_.m_188501_() * 0.4f) * (float)(MutantWitherSkeleton.this.f_19796_.m_188499_() ? 1 : -1)));
            }
        }

        public boolean animationsUseable() {
            return this.mob.ribCrushAnimationTick <= 0;
        }
    }

    class BasicAttackGoal
    extends Goal {
        public MutantWitherSkeleton mob;
        @Nullable
        public LivingEntity target;

        public BasicAttackGoal(MutantWitherSkeleton mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.animationsUseable() && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.max_default_attack_distance.get() && this.mob.m_142582_((Entity)this.target);
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_IDLE.get());
            if (MiscUtils.randomPercent((Integer)MutantWitherSkeletonCommonConfig.strong_attack_chance.get())) {
                Objects.requireNonNull(this.mob);
                this.mob.attackAnimationTickBoth = 40;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)37);
            } else if (MutantWitherSkeleton.this.f_19796_.m_188499_()) {
                this.mob.attackAnimationTickRight = this.mob.attackAnimationLRAnimationLength;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)33);
            } else {
                this.mob.attackAnimationTickLeft = this.mob.attackAnimationLRAnimationLength;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)36);
            }
        }

        public void m_8037_() {
            boolean flag;
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && (this.mob.attackAnimationTickBoth >= this.mob.attackAnimationBothActionPoint || this.mob.attackAnimationTickBoth <= 0)) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.mob.attackAnimationTickLeft == this.mob.attackAnimationLRAnimationLength - 11 || this.mob.attackAnimationTickRight == this.mob.attackAnimationLRAnimationLength - 11) {
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_SWOOSH.get(), 1.0f, 1.0f);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_ATTACK.get(), 1.0f, 1.0f);
            }
            int n = this.mob.attackAnimationTickBoth;
            Objects.requireNonNull(this.mob);
            if (n == 40 - 15) {
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_SWOOSH.get(), 1.0f, 1.0f);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_DOUBLEATTACK.get(), 1.0f, 1.0f);
            }
            if (this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.max_basic_attack_damage_distance.get() && this.mob.attackAnimationTickRight == this.mob.attackAnimationLRActionPoint) {
                if (((Boolean)MutantWitherSkeletonCommonConfig.ignores_invulnerability_time.get()).booleanValue()) {
                    this.target.f_19802_ = 0;
                }
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_SWORD.get(), 1.5f, 1.0f);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_LAND_HIT.get(), 1.5f, 1.0f);
                flag = this.mob.doHurtTarget((Entity)this.target, EquipmentSlot.MAINHAND);
                if (flag) {
                    this.mob.m_5634_(((Double)MutantWitherSkeletonCommonConfig.basic_attack_leech_health_amount.get()).floatValue());
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)10);
                }
                ShakeCameraEvent.shake(this.mob.f_19853_, 15, 0.15f, this.mob.m_20183_(), 10, CameraShakePriority.WEAK_MOB_ACTION);
            }
            if (this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.max_basic_attack_damage_distance.get() && this.mob.attackAnimationTickLeft == this.mob.attackAnimationLRActionPoint) {
                if (((Boolean)MutantWitherSkeletonCommonConfig.ignores_invulnerability_time.get()).booleanValue()) {
                    this.target.f_19802_ = 0;
                }
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_SWORD.get(), 1.5f, 1.0f);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_LAND_HIT.get(), 1.5f, 1.0f);
                flag = this.mob.doHurtTarget((Entity)this.target, EquipmentSlot.OFFHAND);
                if (flag) {
                    this.mob.m_5634_(((Double)MutantWitherSkeletonCommonConfig.basic_attack_leech_health_amount.get()).floatValue());
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)10);
                }
                ShakeCameraEvent.shake(this.mob.f_19853_, 15, 0.15f, this.mob.m_20183_(), 10, CameraShakePriority.WEAK_MOB_ACTION);
            }
            if (this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantWitherSkeletonCommonConfig.max_strong_attack_damage_distance.get() && this.mob.attackAnimationTickBoth == this.mob.attackAnimationBothActionPoint) {
                if (((Boolean)MutantWitherSkeletonCommonConfig.ignores_invulnerability_time.get()).booleanValue()) {
                    this.target.f_19802_ = 0;
                }
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_DOUBLESWORD.get(), 1.5f, 1.0f);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_WITHER_SKELETON_LAND_HIT.get(), 1.5f, 1.0f);
                flag = this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), ((Double)MutantWitherSkeletonCommonConfig.strong_attack_damage.get()).floatValue());
                if (flag) {
                    this.mob.m_5634_(((Double)MutantWitherSkeletonCommonConfig.strong_attack_leech_health_amount.get()).floatValue());
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)10);
                    this.target.m_147207_(new MobEffectInstance(MobEffects.f_19615_, ((Integer)MutantWitherSkeletonCommonConfig.strong_attack_wither_mobs_length.get()).intValue(), ((Integer)MutantWitherSkeletonCommonConfig.strong_attack_wither_mobs_level.get()).intValue()), (Entity)this.mob);
                    this.target.m_20254_(((Integer)MutantWitherSkeletonCommonConfig.strong_attack_set_mob_on_fire_length.get()).intValue());
                } else {
                    this.target.m_147207_(new MobEffectInstance(MobEffects.f_19615_, ((Integer)MutantWitherSkeletonCommonConfig.strong_attack_blocked_wither_mobs_length.get()).intValue(), ((Integer)MutantWitherSkeletonCommonConfig.strong_attack_blocked_wither_mobs_level.get()).intValue()), (Entity)this.mob);
                    this.target.m_20254_(((Integer)MutantWitherSkeletonCommonConfig.strong_attack_blocked_set_mob_on_fire_length.get()).intValue());
                }
                ShakeCameraEvent.shake(this.mob.f_19853_, 30, 0.2f, this.mob.m_20183_(), 15, CameraShakePriority.STRONG_MOB_ACTION);
                MiscUtils.disableShield(this.target, (Integer)MutantWitherSkeletonCommonConfig.strong_attack_disable_shield_length.get());
                for (Mob entity : this.mob.f_19853_.m_6443_(Mob.class, this.target.m_20191_().m_82400_(((Double)MutantWitherSkeletonCommonConfig.strong_attack_area.get()).doubleValue()), MiscUtils.ALIVE)) {
                    boolean flag2;
                    if (entity == this.mob || !this.mob.canHarm((Entity)entity)) continue;
                    if (((Boolean)MutantWitherSkeletonCommonConfig.ignores_invulnerability_time.get()).booleanValue()) {
                        entity.f_19802_ = 0;
                    }
                    if (flag2 = entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), ((Double)MutantWitherSkeletonCommonConfig.strong_attack_area_damage.get()).floatValue())) {
                        entity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, ((Integer)MutantWitherSkeletonCommonConfig.strong_attack_area_wither_mobs_length.get()).intValue(), ((Integer)MutantWitherSkeletonCommonConfig.strong_attack_blocked_wither_mobs_level.get()).intValue()), (Entity)this.mob);
                        entity.m_20254_(((Integer)MutantWitherSkeletonCommonConfig.strong_attack_area_set_mob_on_fire_length.get()).intValue());
                    } else {
                        entity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, ((Integer)MutantWitherSkeletonCommonConfig.strong_attack_area_blocked_wither_mobs_length.get()).intValue(), ((Integer)MutantWitherSkeletonCommonConfig.strong_attack_area_blocked_wither_mobs_level.get()).intValue()), (Entity)this.mob);
                        entity.m_20254_(((Integer)MutantWitherSkeletonCommonConfig.strong_attack_area_blocked_set_mob_on_fire_length.get()).intValue());
                    }
                    MiscUtils.disableShield((LivingEntity)entity, 100);
                }
            }
        }

        public boolean animationsUseable() {
            return this.mob.attackAnimationTickBoth <= 0 && this.mob.attackAnimationTickLeft <= 0 && this.mob.attackAnimationTickRight <= 0;
        }
    }

    static class MutantWitherSkeletonNavigation
    extends GroundPathNavigation {
        public MutantWitherSkeletonNavigation(Mob p_33379_, Level p_33380_) {
            super(p_33379_, p_33380_);
        }

        protected PathFinder m_5532_(int p_33382_) {
            this.f_26508_ = new MutantWitherSkeletonNodeEvaluator();
            return new PathFinder(this.f_26508_, p_33382_);
        }
    }

    static class MutantWitherSkeletonNodeEvaluator
    extends WalkNodeEvaluator {
        MutantWitherSkeletonNodeEvaluator() {
        }

        public void m_6028_(PathNavigationRegion p_77620_, Mob p_77621_) {
            super.m_6028_(p_77620_, p_77621_);
            this.f_77315_ = Mth.m_14143_((float)(p_77621_.m_20205_() + 1.0f));
            this.f_77316_ = Mth.m_14143_((float)MutantWitherSkeleton.crouchingDimensions.f_20378_);
            this.f_77317_ = Mth.m_14143_((float)(p_77621_.m_20205_() + 1.0f));
        }

        public BlockPathTypes m_8086_(BlockGetter p_77576_, int p_77577_, int p_77578_, int p_77579_) {
            if (p_77576_.m_8055_(new BlockPos(p_77577_, p_77578_, p_77579_)).m_204336_(TagInit.Blocks.MUTANT_WITHER_SKELETON_WALKS_THROUGH) && ((Boolean)MutantWitherSkeletonCommonConfig.walk_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue()) {
                return BlockPathTypes.OPEN;
            }
            return MutantWitherSkeletonNodeEvaluator.m_77604_((BlockGetter)p_77576_, (BlockPos.MutableBlockPos)new BlockPos.MutableBlockPos(p_77577_, p_77578_, p_77579_));
        }
    }
}

